 /*-----------------------------------------------------------------------------*
 * File Name: PBSplliter.h		 											*
 * Creation: Frank	 10/26/05													*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Frank 11/14/05 NO_OPERATOR_CONTROL_IN_BROWSER								*
 * Jasmine 11/29/05 QA70-8352 v8.0341 MODIFICATION_FINDCLASS					*
 *	CPY 12/02/2005 USE_FIND_CLASS_TO_PBLIST_BASE_FOR_MORE_EFFICIENT_OC_CODES	*
 * Jasmine 12/16/05 QA70-8352 v8.0347 INHERIT_FROM_TREELISTEDITSPLITTER			*
 * Jasmine 12/16/05 QA70-8352 v8.0347 REMOVE_PBFOLDERSLIST						*
 * Jasmine 12/16/05 QA70-8352 v8.0347 CONTROL_TREE_LEVEL						*
 * Jasmine 04/07/06 v8.0386 SPLITTER_INIT_SIZE_NOT_CALL							*
 * Joseph  09/04/06 ADD_PREVIEW_ON_PROJECT_BROWSER								*
 * Jasmine 12/26/06 SHOW_DEFAULT_FLD_OR_PAGE_OR_LAYER							*
 * Jasmine 04/04/07 MAKE_A_GOOD_COL_WIDTH										*
 * Jasmine, Folger 05/05/07 QA80-9654 IMPROVE_PB_FOR_COLUMN_BROWSER				*
 * Folger 05/08/07 MODIFY_PB_COLUMN_BROWSER										*
 * Folger 05/15/07 FIX_BUG_IN_PB_COLUMN_BROWSER									*
 * Folger 06/06/07 FIX_BUGS_IN_DEFAULT_SHOW										*
 * Folger 06/18/07 MODIFY_GET_SELECTED_PAGE										*
 * Folger 06/20/07 ADD_SHEET_BROWSE												*
 * Folger 06/20/07 CREATE_GET_INIT_RANGE_STRING									*
 * Folger 06/21/07 IMRPOVE_DEFAULT_SHOW											*
 * Folger 07/03/07 CLEAN_UP_GET_RANGE_STRING_CODE								*
 * Jasmine 07/05/07 CORRECT_LOCALIZATION_FORMAT									*
 * Folger 07/13/07 ADD_SHOW_ITEM_TYPE_TO_SPECIFY_BROWSE_PAGE_TYPE				*
 * Folger 07/13/07 EXCLUDE_RESULT_SHEET_IN_COLUMN_BROWSER_IS_NEEDED				*
 * Folger 07/13/07 RESOLVE_DEFAULT_SHOW_STRING_MODIFICATION						*
 * Folger 07/16/07 POPUP_SHOW_HIDE_COLUMN_MENU_IN_PB_LIST						*
 * Folger 07/16/07 SET_PB_COLUMNS_SHOWN_STATE_IS_NEEDED_ACCORDING_TO_DIFFERENT_ORIGIN_OBJECTS
 * Folger 07/17/07 USE_CONTEXT_MENU_IN_PB_LIST_BASE								*
 * Jasmine 07/18/07 SET_SHOW_COLUMN_WITH_VECTOR_UINT							*
 * Jasmine 09/28/07 FILTER_OUT_NON_IMAGE_MATRIX									*
 * Kyle 07/15/08 FUNCTION_GETDEFAULTSHOW_WAS_CHANGED							*
 * Kyle 07/16/08 QA80-11840 ADD_FUNCTION_SETSHOWCOLUMNS							*
 * Kyle 07/16/08 SET_FILTER_OF_PBLISTBASE										*
 * Jasmine 02/21/10 QA81-14826-P2 ADD_CONTEXT_MENU_TO_PB_TREE					*
 * Jasmine 02/21/10 QA81-14826-P3 WANT_LIST_VIEW_OPTION							*
 * Bill	07/09/2010 QA81-14826-P2 SHOW_LONG_NAME_AND_LIST_VIEW_MENU				*
 *------------------------------------------------------------------------------*/
#ifndef _PB_FUNCTION_LIST_H
#define _PB_FUNCTION_LIST_H


///Jasmine 02/21/10 QA81-14826-P2 ADD_CONTEXT_MENU_TO_PB_TREE
enum{
	PB_TREE_MENU_SHOW_LN,
	PB_TREE_MENU_LIST_VIEW,	///Jasmine 02/21/10 QA81-14826-P3 WANT_LIST_VIEW_OPTION
	
	PB_TREE_MENU_ALL_ITEMS	
};

#define STR_SHOW_LONG_NAME "ShowLongName"

#include <Tree_utils.h>

class PBTreeMenu : public Menu
{
public:
	/// Bill 07/09/2010 QA81-14826-P2 SHOW_LONG_NAME_AND_LIST_VIEW_MENU
	//PBTreeMenu(bool bLName = false, bool bListView = false)
	/// End SHOW_LONG_NAME_AND_LIST_VIEW_MENU
	PBTreeMenu(bool bLName = false)
	{
		m_nChoice = -1;
		Add(_L("Show Long Name"), OnMenuItem,  MF_STRING | (bLName ? MF_CHECKED: MF_UNCHECKED));
		/// Bill 07/09/2010 QA81-14826-P2 SHOW_LONG_NAME_AND_LIST_VIEW_MENU
		//Add(_L("List View"), OnMenuItem,  MF_STRING | (bListView ? MF_CHECKED: MF_UNCHECKED));
		/// End SHOW_LONG_NAME_AND_LIST_VIEW_MENU
	}

	void OnMenuItem(UINT nPos)
	{
		m_nChoice = nPos;
	}

	bool GetCommand(int& nChoice)
	{
		if(PB_TREE_MENU_SHOW_LN <= m_nChoice && m_nChoice < PB_TREE_MENU_ALL_ITEMS)
		{
			nChoice = m_nChoice;
			return true;
		}
		return false;
	}
	void EmptySepFunc(uint nCmd)
	{
	}
private:
	int	m_nChoice;
};
///End ADD_CONTEXT_MENU_TO_PB_TREE


//----- CPY 12/02/2005 USE_FIND_CLASS_TO_PBLIST_BASE_FOR_MORE_EFFICIENT_OC_CODES
// the followings are changed into .c files for better efficiency
//#include "pbPagelist.h"
//#include "pblayerlist.h"
//-----
#include "TreeEditSplitter.h"

#define IDR_MAINFRAME                   480
#define ID_VIEW_DOCUMENT_LINK			0X8549

#define		WM_USER_ON_NAME_CHANGE  (WM_USER + 1011)
#define		WM_USER_ON_DBCLICK_SELETED  (WM_USER + 1012)
#define MENU_BASE_OFFERT_OF_NEW_WINDOW		1000


#define		PB_FOLDER_SHOW_SEPARATE_CHAR	'/'
	

///----Show option, will save to reg
enum PBLISTShowOption
{
	//ATRN_SHOW_ALL  = 0x0,   	//default,
	ATRN_SHOW_FOLDER   = 0x00010000, 
	ATRN_SHOW_HIDDEN   = 0x00020000, 
	ATRN_SHOW_MINIMIZED     = 0x00040000, 	
	ATRN_SHOW_LAST_ENTRY,
};
///----

/// Bill 07/09/2010 QA81-14826-P2 SHOW_LONG_NAME_AND_LIST_VIEW_MENU
enum {
	LIST_SHORT_NAME_COL,
	LIST_LONG_NAME_COL,
};
/// End SHOW_LONG_NAME_AND_LIST_VIEW_MENU

//class PBSplliter: public SplitterControl	///Jasmine 12/16/05 INHERIT_FROM_TREELISTEDITSPLITTER
class PBSplliter: public TreeListEditSplitter
{
private:
	
public:
	PBSplliter()
	{
		/////------Frank 11/14/05 Temp, if have better solution, will change it.
		//m_pPBList = new PROJECT_LIST_CLASS;
//
		//m_PBBrowserType = m_pPBList->GetPBListType();
		m_pPBList = NULL;//CPY
		///Joseph  09/04/06 ADD_PREVIEW_ON_PROJECT_BROWSER
		//m_bSupportMultiSelected = false;
		m_bSupportMultiSelected = true;
		///End ADD_PREVIEW_ON_PROJECT_BROWSER
		m_bReady = false;
		// control ID for panes
		// Must init these IDs before calls to InitMsgMap
		//SetGridSize(1,2);
		///Jasmine 12/16/05 INHERIT_FROM_TREELISTEDITSPLITTER
		/*
		m_IDfolders = GetDlgCtrlID(PB_PANE_ROW_COL_FOLDERS);
		m_IDpages = GetDlgCtrlID(PB_PANE_ROW_COL_PAGES);
		*/
		///End INHERIT_FROM_TREELISTEDITSPLITTER
		m_bIncludeShortcut = false;			///Jasmine 04/27/10 QA81-14826-P5 BROWSER_HAS_INCLUDE_SHORTCUT_OPTION
		m_nPageFilterType	= -1;
		m_nLevel = PTL_FOLDER;	///Jasmine 12/16/05 CONTROL_TREE_LEVEL
		InitMsgMap();
	}
	///Kyle 07/16/08 QA80-11840 ADD_FUNCTION_SETSHOWCOLUMNS
	BOOL SetShowColumns(const vector<uint>& vnShowColumns = NULL)
	{
		return m_pPBList->SetShowColumns(vnShowColumns);
	}
	///End ADD_FUNCTION_SETSHOWCOLUMNS
	bool ConstructListPointer(int nType = PB_BROWSER_PAGE_LIST)
	{
		if(m_pPBList && m_pPBList->GetPBListType()== nType)
				return true;
		//-------- CPY 12/02/2005 USE_FIND_CLASS_TO_PBLIST_BASE_FOR_MORE_EFFICIENT_OC_CODES
		/*
		if(m_pPBList)
			delete m_pPBList;
		///Jasmine 11/29/05 QA70-8352 v8.0341 MODIFICATION_FINDCLASS
		string strClass;
		switch(nType)	
		{
		case PB_BROWSER_PAGE_LIST:
			m_pPBList = new PBPageList;	
			strClass = "PBPageList";
			break;
		case PB_BROWSER_LAYER_LIST:
			m_pPBList = new PBLayerList;
			strClass = "PBLayerList";
			break;
		default:
			return false;
		}
		//PBListBase& PBList = (PBListBase&) Project.CreateClass(strClass); //CPY 11/30/05, change from FindClass
		////InitGridList(&PBList);
		//m_pPBList = &PBList;
		///End MODIFICATION_FINDCLASS
		*/
		m_pPBList = NULL;
		string strClass;
		switch(nType)	
		{
		case PB_BROWSER_PAGE_LIST:
			strClass = "PBPageList";
			break;
		case PB_BROWSER_LAYER_LIST:
			strClass = "PBLayerList";
			break;
		case PB_BROWSER_OBJECT_LIST:	///Jasmine, Folger 05/05/07 QA80-9654 IMPROVE_PB_FOR_COLUMN_BROWSER
			strClass = "PBObjectList";
			break;
		default:
			break;
		}
		if(!strClass.IsEmpty())
		{
			PBListBase& PBList = (PBListBase&) Project.FindClass(strClass);
			m_pPBList = &PBList;
		}
		//------------------------------ end USE_FIND_CLASS_TO_PBLIST_BASE_FOR_MORE_EFFICIENT_OC_CODES
		if(m_pPBList == NULL)
			return false;
		m_strGridListClass = strClass;///Jasmine 12/16/05 SET_CLASS_NAME_ATTRIB
		m_PBBrowserType = nType;
		return true;
	}
	~PBSplliter()
	{
		//delete m_pPBList;CPY moved to OnDestroy
	}
	//---------Folger 07/13/07 EXCLUDE_RESULT_SHEET_IN_COLUMN_BROWSER_IS_NEEDED
	//void Init(int nID, Dialog& dlg, LPCSTR lpcszDlgName ,int nListType = PB_BROWSER_PAGE_LIST, int nIDFolderCombo = 0, int nIDFolderComboLabel = 0, 
				//int nIDPageTypeCombo =0, int nIDPageTypeComboLabel =0, int nIDPageNameText =0,
				//int nIDPageNameLabel= 0, int nIDFolderUPer =0)
	void Init(int nID, Dialog& dlg, LPCSTR lpcszDlgName ,int nListType = PB_BROWSER_PAGE_LIST, int nIDFolderCombo = 0, int nIDFolderComboLabel = 0, 
				int nIDPageTypeCombo =0, int nIDPageTypeComboLabel =0, int nIDPageNameText =0,
				int nIDPageNameLabel= 0, int nIDFolderUPer =0, DWORD dwFilter = 0)
	//---------End EXCLUDE_RESULT_SHEET_IN_COLUMN_BROWSER_IS_NEEDED
	{
		m_strDlgName = lpcszDlgName;
		///----Frank 11/22/05
		ConstructListPointer(nListType);
		///----End
		
		//SplitterControl::Init(nID, dlg, 1, lpcszDlgName);// 1 = 2nd splitter in dialog	///Jasmine 12/16/05 INHERIT_FROM_TREELISTEDITSPLITTER		///Jasmine 12/12/05
		TreeListEditSplitter::Init(nID, dlg, lpcszDlgName);	
		
		///Joseph  09/04/06 ADD_PREVIEW_ON_PROJECT_BROWSER
		//if(nIDPageNameText)
			//m_edName = dlg.GetItem(nIDPageNameText);
		//if(nIDFolderUPer)
		//{
			//m_chkUpBottom = dlg.GetItem(nIDFolderUPer);
		//
			//vector<string> vsToolTipsShow =  { "Up one level" };
//
			//if(isAppendControlValid(PB_CNTL_UP_BOTTON))
				//m_chkUpBottom.Init(2, IDB_FOLDER_UP_BTN, 13, vsToolTipsShow);
		//}
		//if(nIDFolderCombo)
			//m_comFolderList = dlg.GetItem(nIDFolderCombo);
		///End ADD_PREVIEW_ON_PROJECT_BROWSER
		if(nIDPageTypeCombo)
			m_comTypeList = dlg.GetItem(nIDPageTypeCombo);

		///Set Type first, because we need check the show type..
		loadProjectBrowserType(m_vnTypeList);
		SetSettings();
		
		///Select default row of Folder list of left pane ....
		///Joseph  09/04/06 ADD_PREVIEW_ON_PROJECT_BROWSER
		//setFolderListSel(0);
		///End ADD_PREVIEW_ON_PROJECT_BROWSER
		SetActive(0);
		///Joseph  09/04/06 ADD_PREVIEW_ON_PROJECT_BROWSER
		//updateFolderComboList();
		///End ADD_PREVIEW_ON_PROJECT_BROWSER
		///m_vbViewState store the page and folder show state, default show all.. true mean hide, else show
		///m_vbViewState[0] save folder show state, 
		///m_vbViewState[1] save hide page show state, 
		///m_vbViewState[2] save minimax page show state.. the show state have hide or show.
		m_vbViewState.SetSize(3);
		m_vbViewState = false;
		
		//SetSettings();
		
		m_dwFilter = dwFilter;//m_bResultSheet = bResultSheet;	//---------Folger 07/13/07 EXCLUDE_RESULT_SHEET_IN_COLUMN_BROWSER_IS_NEEDED///Jasmine 09/28/07 FILTER_OUT_NON_IMAGE_MATRIX	
		///Kyle 07/16/08 SET_FILTER_OF_PBLISTBASE
		m_pPBList->SetShowFilter(m_dwFilter);
		///End SET_FILTER_OF_PBLISTBASE
	}
	///Set the splitter setting, set the selected mode and show page type.
	///nSelectedMode can be MULTIPLE_SELECT and SINGLE_SELECT, mean multiple select the items and single one selected.
	///nOnlyShowLayers can be 	EXIST_WKS, EXIST_GRAPH, EXIST_MATRIX, EXIST_LAYOUT, EXIST_NOTES, EXIST_NONE
	///EXIST_WKS mean only show worksheet or workbook in browser.
	///EXIST_NONE mean can show all page and layers.
	bool SetSettings()
	{
		m_pPBList->SetSelectMode( m_nSelectMode );
		setBrowserShowType(m_nPageFilterType);
		
		if(m_nSelectMode == MULTIPLE_SELECT)
			m_bSupportMultiSelected = true;
		return true;
	}

	bool setBrowserShowType(int &nOnlyShowLayers)
	{
		///Joseph  09/04/06 ADD_PREVIEW_ON_PROJECT_BROWSER
		//if(!isAppendControlValid(PB_CNTL_TYPE_LIST))
		if(!isAppendControlValid()) 
		///End ADD_PREVIEW_ON_PROJECT_BROWSER
			return true;
		vector<uint> vn;
		if(m_vnTypeList.Find(vn, nOnlyShowLayers)<=0)
			nOnlyShowLayers = m_vnTypeList[0];
		
		switch(nOnlyShowLayers)
		{
		case EXIST_NONE:
			return true;
		default:
			break;
		}
		setFilterPageType(nOnlyShowLayers);
		///If type list =1 , mean only show one type of the origin object. so the comtypelist should not able to edit
		if(m_vnTypeList.GetSize() == 1)
			m_comTypeList.Enable = false;
		return true;
	}
	///Jasmine 12/26/06 SHOW_DEFAULT_FLD_OR_PAGE_OR_LAYER
	/// "/" mean rootfolder, "/My" mean name "My" folder under root folder, "/My/Subf" mean subf under my folder
	//void SetPageListDefault(LPCSTR lpcszFolderPath = NULL, LPCSTR lpcszPageName = NULL, int nSelectedType = EXIST_NONE, bool bChangeableTypeSlete = true)
	void SetPageListDefault(LPCSTR lpcszDefaultShow = NULL, int nSelectedType = EXIST_NONE, bool bChangeableTypeSlete = true)
	{
		/*
		bool bSelActiveFolder = false;
		if(lpcszFolderPath == NULL && lpcszPageName == NULL )
			bSelActiveFolder = true;

		Folder fldr(lpcszFolderPath);
		PageBase pg(lpcszPageName);
			int nDefaultRow =0;
		
		if(bSelActiveFolder)
		{
			fldr = Project.ActiveFolder();
		}
		else
			if(pg)
			{
				fldr = pg.GetFolder();
			}

		string strFolderPath = fldr.GetPath();
		*/
		int nRow = -1;
		///Sophy CLEAN_CODE_PBLIST_CONTROL
		/*
		string strDefaultShow(lpcszDefaultShow);
		///Folger 06/21/07 IMRPOVE_DEFAULT_SHOW
		//Folder fldr(strDefaultShow);
		//if(lpcszDefaultShow == NULL)
		//{
			//fldr = Project.ActiveFolder();
			//strDefaultShow = fldr.GetPath();
		//}
		///End IMRPOVE_DEFAULT_SHOW
		///Folger 05/15/07 FIX_BUG_IN_PB_COLUMN_BROWSER
		//if(lpcszDefaultShow == NULL)
		{
			//-----Folger 07/13/07 RESOLVE_DEFAULT_SHOW_STRING_MODIFICATION
			//Worksheet wks = Project.ActiveLayer();
			//if (wks)
			Layer lay = Project.ActiveLayer();
			if (lay)
			//-----End RESOLVE_DEFAULT_SHOW_STRING_MODIFICATION
			{
				//strDefaultShow = "[" + wks.GetPage().GetName() + "]" + wks.GetName();
				///Folger 06/21/07 IMRPOVE_DEFAULT_SHOW
				//wks.GetRangeString(strDefaultShow);
				if (m_PBBrowserType == PB_BROWSER_OBJECT_LIST)
				{
					//--------Folger 07/03/07 CLEAN_UP_GET_RANGE_STRING_CODE
					//wks.GetRangeString(strDefaultShow);
					if (strDefaultShow == NULL)
					{
						//-----Folger 07/13/07 RESOLVE_DEFAULT_SHOW_STRING_MODIFICATION
						//wks.GetRangeString(strDefaultShow);
						lay.GetRangeString(strDefaultShow);
						//-----End RESOLVE_DEFAULT_SHOW_STRING_MODIFICATION
						strDefaultShow.TrimRight('!');
					}
					else
					{
						string strBook, strSheet, strCol;
						okutil_parse_complete_range_string(strDefaultShow, strBook, strSheet, strCol);
						okutil_create_complete_range_string_obj(strDefaultShow, strBook, strSheet, NULL);
					}
					nRow = m_pTree->FindRow(strDefaultShow);
					//--------end CLEAN_UP_GET_RANGE_STRING_CODE
				}
				else if (m_PBBrowserType == PB_BROWSER_LAYER_LIST)
				{
					//--------Folger 07/03/07 CLEAN_UP_GET_RANGE_STRING_CODE
					//Page pg = wks.GetPage();
					//pg.GetRangeString(strDefaultShow);
					if (strDefaultShow == NULL)
					{
						//-----Folger 07/13/07 RESOLVE_DEFAULT_SHOW_STRING_MODIFICATION
						//Page pg = wks.GetPage();
						Page pg = lay.GetPage();
						//-----End RESOLVE_DEFAULT_SHOW_STRING_MODIFICATION
						pg.GetRangeString(strDefaultShow);
					}
					string strBook, strSheet;
					okutil_get_book_sheet_info(&strBook, &strSheet, strDefaultShow);
					nRow = m_pTree->FindRow(strBook);
					//--------end CLEAN_UP_GET_RANGE_STRING_CODE
				}
				else
				{
					//--------Folger 07/03/07 CLEAN_UP_GET_RANGE_STRING_CODE
					//Folder fldr = Project.ActiveFolder();
					//strDefaultShow = fldr.GetPath();
					if (strDefaultShow == NULL)
					{
						Folder fldr = Project.ActiveFolder();
						strDefaultShow = fldr.GetPath();
					}
					strDefaultShow.TrimLeft('/');
					strDefaultShow.TrimRight('/');
					vector<string> vs;
					strDefaultShow.GetTokens(vs, '/');
					for(int ii = 0; ii < vs.GetSize(); ii++)
					{
						int nLevel = -1;
						while(nLevel != ii)
						{
							nRow = m_pTree->FindRow(vs[ii], 0, false, true, nRow + 1);
							nLevel = nRow == -1? ii : m_pTree->GetLevel(nRow);
						}
					}
					//--------end CLEAN_UP_GET_RANGE_STRING_CODE
				}
				///End IMRPOVE_DEFAULT_SHOW
			}
		}
		///End FIX_BUG_IN_PB_COLUMN_BROWSER
		//--------Folger 07/03/07 CLEAN_UP_GET_RANGE_STRING_CODE
		//if(strDefaultShow.Right(1).Compare("/"))//it's not a path strinng
		/////Folger 05/08/07 MODIFY_PB_COLUMN_BROWSER
		////nRow = m_pTree->FindRow(strDefaultShow);
		//{
			//int nIndex;
			//string str;
			//if ((nIndex = strDefaultShow.Find('!')) != -1)
			//{
				//str = strDefaultShow.Mid(0, nIndex);
				//nRow = m_pTree->FindRow(strDefaultShow.Mid(0, nIndex));		///Folger 06/06/07 FIX_BUGS_IN_DEFAULT_SHOW
			//}
			//else
			//{
				/////Folger 06/20/07 ADD_SHEET_BROWSE
				////nRow = m_pTree->FindRow(strDefaultShow);
				//string strBook, strSheet;
				//okutil_get_book_sheet_info(&strBook, &strSheet, strDefaultShow);
				//nRow = m_pTree->FindRow(strBook);
				/////End ADD_SHEET_BROWSE
			//}
		//}
		///End MODIFY_PB_COLUMN_BROWSER
		//else
		//{
			//strDefaultShow.TrimLeft('/');
			//strDefaultShow.TrimRight('/');
			//vector<string> vs;
			//strDefaultShow.GetTokens(vs, '/');
			//for(int ii = 0; ii < vs.GetSize(); ii++)
			//{
				//int nLevel = -1;
				//while(nLevel != ii)
				//{
					//nRow = m_pTree->FindRow(vs[ii], 0, false, true, nRow + 1);
					//nLevel = nRow == -1? ii : m_pTree->GetLevel(nRow);
				//}
			//}
		//}
		//--------end CLEAN_UP_GET_RANGE_STRING_CODE
		*/
		Layer lay = Project.ActiveLayer();
		///Kyle 07/15/08 FUNCTION_GETDEFAULTSHOW_WAS_CHANGED
		//nRow = m_pPBList->GetDefaultShow( lay, m_PBBrowserType, m_pTree, lpcszDefaultShow );
		nRow = m_pPBList->GetDefaultShow( lay, m_pTree, lpcszDefaultShow );
		///End FUNCTION_GETDEFAULTSHOW_WAS_CHANGED
		///end Sophy CLEAN_CODE_PBLIST_CONTROL
		m_pTree->SelRow(nRow);	
	///End SHOW_DEFAULT_FLD_OR_PAGE_OR_LAYER
		///Joseph  09/04/06 ADD_PREVIEW_ON_PROJECT_BROWSER
		//ActiveFolderListWhenFolderChanged(strFolderPath);
		///End ADD_PREVIEW_ON_PROJECT_BROWSER
		if(!bChangeableTypeSlete)
			///Joseph  09/04/06 ADD_PREVIEW_ON_PROJECT_BROWSER
			//if(isAppendControlValid(PB_CNTL_TYPE_LIST))
			if(isAppendControlValid())
			///End ADD_PREVIEW_ON_PROJECT_BROWSER
				m_comTypeList.Enable = false;
	}
	///Jasmine 12/13/05 SPLITTER_INIT_SIZE_ON_READY
	void OnReady()
	{
		SplitterControl::OnReady();
		
	}
	///End SPLITTER_INIT_SIZE_ON_READY
protected:
EVENTS_BEGIN
	ON_INIT(OnInitDialog)
	ON_DESTROY(OnDestroy)
	ON_SIZE(OnCtrlResize)
	ON_CHANGE_LAYER(OnActiveLayerChange)
	///Jasmine 12/16/05 INHERIT_FROM_TREELISTEDITSPLITTER	
	/*
	ON_GRID_ROW_COL_CHANGE(m_IDfolders, OnUpdateFolderList)
	ON_GRID_SEL_CHANGE(m_IDpages, OnPageSelChange)
	
	ON_GRID_DBLCLICK(m_IDfolders, OnFolderSelected)
	ON_GRID_DBLCLICK(m_IDpages, OnBrowserListFolderSelted)
	*/
	ON_GRID_ROW_COL_CHANGE(m_nIDTree, OnSelectTreeNode)
	ON_GRID_SEL_CHANGE(m_nIDList, OnPageSelChange)	
	ON_GRID_DBLCLICK(m_nIDTree, OnFolderSelected)
	//---Jasmine 03/08/10 QA81-14826 doing, not ready
	ON_GRID_BEFORE_MOUSE_DOWN(m_nIDTree, OnBeforeMouseDownInTree)///Jasmine 02/21/10 QA81-14826-P2 ADD_CONTEXT_MENU_TO_PB_TREE
	//---
	///Joseph  09/04/06 ADD_PREVIEW_ON_PROJECT_BROWSER
	ON_GRID_DBLCLICK(m_nIDList, OnBrowserListFolderSelted)///Jasmine 12/27/06 PUT_BACK_DBCLICK_IN_LIST_PANEL
	///End ADD_PREVIEW_ON_PROJECT_BROWSER
	///End INHERIT_FROM_TREELISTEDITSPLITTER	
	///Joseph  09/04/06 ADD_PREVIEW_ON_PROJECT_BROWSER
	ON_CBN_SELCHANGE(IDC_PB_TYPE_COMBO, OnTypeChange)
	///End ADD_PREVIEW_ON_PROJECT_BROWSER
	 //ON_GRID_BEFORE_MOUSE_DOWN(m_IDpages, OnBeforeMouseDown)	///Jasmine 12/16/05 INHERIT_FROM_TREELISTEDITSPLITTER	
	 ON_GRID_BEFORE_MOUSE_DOWN(m_nIDList, OnBeforeMouseDown)
	ON_USER_MSG(WM_USER_RESIZE_CONTROLS, OnInitPaneSizs)	///Jasmine 04/07/06 SPLITTER_INIT_SIZE_NOT_CALL
EVENTS_END

	BOOL OnInitDialog()
	{
		m_bReady = false;
		///Jasmine 12/16/05 INHERIT_FROM_TREELISTEDITSPLITTER			
		//GUID clsid; // later, for now, only vsFlex
		
		//CreateActiveXPane(clsid, PB_PANE_ROW_COL_FOLDERS);	
		
		//CreateActiveXPane(clsid, PB_PANE_ROW_COL_PAGES);

		//m_pPBList->Init(m_IDpages, *this, m_strDlgName);
		//m_folders.Init(m_IDfolders, *this);
		TreeListEditSplitter::OnInitDialog();
		//-----Folger 07/13/07 ADD_SHOW_ITEM_TYPE_TO_SPECIFY_BROWSE_PAGE_TYPE
		//m_pPBList->Init(m_nIDList, *this, m_strDlgName);
		m_pPBList->Init(m_nIDList, *this, m_strDlgName, m_nPageFilterType);
		///Jasmine 07/18/07 SET_SHOW_COLUMN_WITH_VECTOR_UINT
		vector<uint> vnDisplayCols = {	PEOBJECT_INDEX, PEOBJECT_SNAME, 
										PEOBJECT_LNAME, PEOBJECT_COMMENTS,
										PEOBJECT_DESIGNATION,
										PEOBJECT_FORMAT,PEOBJECT_SIZE,
										PEOBJECT_FIRSTVALUE,	//------ Folger 07/26/07 ADD_FIRSTVALUE_IN_OBJECT_LIST
										PEOBJECT_PARAM,	PEOBJECT_UDL };
		m_pPBList->SetShowColumns(vnDisplayCols);		//--------Folger 07/17/07 USE_CONTEXT_MENU_IN_PB_LIST_BASE
		///End SET_SHOW_COLUMN_WITH_VECTOR_UINT
		//-----End ADD_SHOW_ITEM_TYPE_TO_SPECIFY_BROWSE_PAGE_TYPE
		///End		
		int nShowPageTypeInFolderList = 0;
		//if(isLayerBrowserList())	///Jasmine 12/25/06 BOTH_TREE_PANEL_AND_PBLIST_SHOULD_SHOW_THE_SAME_TYPE
			nShowPageTypeInFolderList = m_nPageFilterType;

		/// Bill 07/09/2010 QA81-14826-P2 SHOW_LONG_NAME_AND_LIST_VIEW_MENU
		DWORD dwShow;
		dlg_load_registry(STR_DLG_NAME, STR_SHOW_LONG_NAME, dwShow, 1);
		m_bShowLongName = dwShow;
		m_bShowTreeView = true;
		/// End SHOW_LONG_NAME_AND_LIST_VIEW_MENU
		
		///Jasmine 12/16/05 INHERIT_FROM_TREELISTEDITSPLITTER
		//m_folders.Init(m_IDfolders, *this ,nShowPageTypeInFolderList);
		//m_folders.Init(m_nIDTree, *this ,nShowPageTypeInFolderList);
		InitTreePanel(nShowPageTypeInFolderList);
		///End INHERIT_FROM_TREELISTEDITSPLITTER	
		SetReady();
		//m_bReady = true; //Sophy duplicate logic : SetReady() means m_bReady = true

		return TRUE;
	}
	///Jasmine 12/16/05 INHERIT_FROM_TREELISTEDITSPLITTER
	void InitTreePanel(int nShowPageType = EXIST_NONE)
	{
		m_pTree->SetSelection( flexSelectionListBox );		///Folger 05/30/07 FIX_BUG_IN_PB_COLUMN_BROWSER_SINGLE_SELECTED2
		UpdateTreePanel(nShowPageType);
	}
	bool UpdateTreePanel(int nShowPageType = EXIST_NONE)
	{		
		m_tree.Reset();
		//tree_get_project_folders_and_pages(m_tree, nShowPageType);
		///Jasmine 04/27/10 QA81-14826-P5 BROWSER_HAS_INCLUDE_SHORTCUT_OPTION
		///Jasmine 04/27/10 QA81-14826-P5 COMBINE_BOOL_IN_DWORD_TO_SIMPLIFY_FUNC_INTERFACE
		//bool flag = get_project_tree(m_tree, m_nLevel, nShowPageType);
		ProjectTreeOptions stOptions;
		if(m_bIncludeShortcut)
			stOptions.dwCtrl = PT_CTRL_INCLUDE_SHORTCUT;
		bool flag = get_project_tree(m_tree, m_nLevel, nShowPageType, 0, NULL, stOptions);
		///End BROWSER_HAS_INCLUDE_SHORTCUT_OPTION
		///End COMBINE_BOOL_IN_DWORD_TO_SIMPLIFY_FUNC_INTERFACE
		//---------Folger 07/13/07 EXCLUDE_RESULT_SHEET_IN_COLUMN_BROWSER_IS_NEEDED
		if(m_dwFilter & SCD_NO_RESULT_SHEET)//(!m_bResultSheet)///Jasmine 09/28/07 FILTER_OUT_NON_IMAGE_MATRIX	
			excludeResultSheet(m_tree);
		//---------End EXCLUDE_RESULT_SHEET_IN_COLUMN_BROWSER_IS_NEEDED
		//set class name...
		SetClassNameAttrib();///Jasmine 12/16/05 SET_CLASS_NAME_ATTRIB
		m_pTree->ClearAll();

		/// Bill 07/09/2010 QA81-14826-P2 SHOW_LONG_NAME_AND_LIST_VIEW_MENU
		// return m_pTree->AddTreeNodes(m_tree, ATRN_LOOP_MARDED_NODE_ONLY, STR_DISPLAY_ATTRIB);
		if ( !m_pTree->AddTreeNodes(m_tree, ATRN_LOOP_MARDED_NODE_ONLY, STR_DISPLAY_ATTRIB) )
			return false;

		ShowNameInTree();

		return true;
		/// End SHOW_LONG_NAME_AND_LIST_VIEW_MENU
	}
	///End INHERIT_FROM_TREELISTEDITSPLITTER
	
	/// Bill 07/09/2010 QA81-14826-P2 SHOW_LONG_NAME_AND_LIST_VIEW_MENU
	virtual BOOL OnSelectTreeNode(Control cntrl)
	{
		if(!m_bReady)
			return FALSE;

		int nSelRow = m_pTree->GetSelectedRow();
		if(nSelRow <= 0)
			return FALSE;

		TreeNode trNode = GetSelectedTreeNode(nSelRow);
	
		return UpdateListPanel(trNode);
	}

	TreeNode GetSelectedTreeNode(int nSelRow)
	{
		TreeNode trNode;

		if ( m_bShowTreeView )
			trNode = tree_get_node(m_tree, nSelRow);
		else
		{	
			string strShortName = m_pTree->GetCell(nSelRow, LIST_SHORT_NAME_COL);
			string strLabel;
			for (int nRow = nSelRow ; /* empty */ ; ++nRow)
			{
				trNode = tree_get_node(m_tree, nRow);
				
				trNode.GetAttribute(STR_LABEL_ATTRIB, strLabel);

				if ( strShortName == strLabel )
					break;
			}
		}

		return trNode;
	}

	TreeNode GetTreeNodeBySaveName()
	{
		return m_tree.FindNodeByAttribute(STR_LABEL_ATTRIB, m_strSelectedName);
	}

	int GetRowNumberBySaveName()
	{
		string strLabel;
		int nRow;

		if ( m_bShowTreeView )
		{
			TreeNode trRow;

			for (nRow = 0 ; /* empty */ ; ++nRow)
			{
				trRow = tree_get_node(m_tree, nRow);
				if ( !trRow.IsValid() )
					break;
				
				trRow.GetAttribute(STR_LABEL_ATTRIB, strLabel);
				if ( m_strSelectedName == strLabel )
					return nRow;
			}
		}
		else
		{
			for (nRow = 0 ; nRow < m_pTree->GetRows() ; ++nRow)
			{
				strLabel = m_pTree->GetCell(nRow, LIST_SHORT_NAME_COL);
				if ( m_strSelectedName == strLabel )
					return nRow;
			}
		}
	}
	
	bool ShowListPanel(int nShowPageType = EXIST_NONE)
	{
		m_pTree->SetSelection(flexSelectionListBox);

		m_pTree->ClearAll();

		GetProjectTree(m_tree, nShowPageType);

		SetClassNameAttrib();
		
		SetupColHeader();

		vector<string> vsShortNames;
		vector<string> vsLongNames;
		
		GetShortAndLongName(vsShortNames, vsLongNames);

		SetListPaneSizeAndValue(vsShortNames, vsLongNames);

		ShowNameInList();

		return true;
	}

	void GetProjectTree(Tree & trProjectTree, int nShowPageType)
	{
		trProjectTree.Reset();

		ProjectTreeOptions stOptions;
		if(m_bIncludeShortcut)
			stOptions.dwCtrl = PT_CTRL_INCLUDE_SHORTCUT;
		
		get_project_tree(trProjectTree, m_nLevel, nShowPageType, 0, NULL, stOptions);

		if(m_dwFilter & SCD_NO_RESULT_SHEET)
			excludeResultSheet(trProjectTree);
	}

	void SetupColHeader()
	{
		vector<string> vsColHeaders;
		vsColHeaders.Add( _L("Short Name") );
		vsColHeaders.Add( _L("Long Name") );

		m_pTree->SetupRowsCols(1, 0,  1, vsColHeaders.GetSize());

		for( int ii = 0; ii < vsColHeaders.GetSize(); ii++ )
		{
			m_pTree->SetColHeading(ii, vsColHeaders[ii]);
		}
	}

	void GetShortAndLongName(vector<string> & vsShortNames, vector<string> & vsLongNames)
	{
		string strLongName, strShortName;
		int nLevel;

		for (int nRow = 0 ; /* empty */ ; ++nRow)
		{
			TreeNode trRow = tree_get_node(m_tree, nRow);
			if(!trRow.IsValid())
				break;
			
			trRow.GetAttribute(STR_STOP_ATTRIB, nLevel);
			if(PTL_PAGE != nLevel)
				continue;

			trRow.GetAttribute(STR_LABEL_ATTRIB, strShortName);
			trRow.GetAttribute(STR_NAME_ATTRIB, strLongName);

			vsShortNames.Add(strShortName);
			vsLongNames.Add(strLongName);
		}
	}

	void SetListPaneSizeAndValue(const vector<string> & vsShortNames, const vector<string> & vsLongNames)
	{
		int nSelRow = m_pTree->GetSelectedRow();
		m_pTree->SetColValues(LIST_SHORT_NAME_COL, vsShortNames, 0, true);
		m_pTree->SetColValues(LIST_LONG_NAME_COL, vsLongNames, 0, true);		
		if( -1 == nSelRow)		
		{
			nSelRow = 1; // add 1 since the first row is column header			
		}
		m_pTree->SelRow(nSelRow);

		m_pTree->ResizeCols();
	}
	/// End SHOW_LONG_NAME_AND_LIST_VIEW_MENU

	BOOL	OnDestroy()
	{
		if(m_pPBList) //CPY
		{
			m_pPBList->OnDestroy();	///To save the pb list setting.
			//-------- CPY 12/02/2005 USE_FIND_CLASS_TO_PBLIST_BASE_FOR_MORE_EFFICIENT_OC_CODES
			// pointer from FindClass do not delete
			//delete m_pPBList;
			//--------
		}
		SplitterControl::OnDestroy();

		/// Bill 07/09/2010 QA81-14826-P2 SHOW_LONG_NAME_AND_LIST_VIEW_MENU
		dlg_save_to_registry(STR_DLG_NAME, STR_SHOW_LONG_NAME, m_bShowLongName);
		/// End SHOW_LONG_NAME_AND_LIST_VIEW_MENU

		return TRUE;
	}

	BOOL OnCtrlResize(int nType, int cx, int cy)
	{
		_DMSG_PB("On ctrl resize begin");
		SplitterControl::OnResize(nType, cx, cy);

		m_pPBList->ResizeCols(3, 1);	///Temp....
		_DMSG_PB("m_pPBList resize success");
		_DMSG_PB("On ctrl resize success");
		return TRUE;
	}
	///Jasmine 12/16/05 REMOVE_PBFOLDERSLIST
	/*
	void OnUpdateFolderList(Control cntrl)
	{
		if(!m_bReady)
			return;
		//_DMSG_PB("PE folder sel changes");
		int nSelRow =0 ;
		Folder fldr = m_folders.GetSelectedFolder(nSelRow);
		setFolderListSel(nSelRow);
		SetActive(nSelRow);
		m_pPBList->UpdateList(fldr, m_nPageFilterType);
	}
	*/
	///End REMOVE_PBFOLDERSLIST
	///Jasmine 12/16/05 INHERIT_FROM_TREELISTEDITSPLITTER
	BOOL CreateGridList(string strGridList)
	{
		if(m_pPBList)
			delete m_pPBList;
		//-------- CPY 11/30/05 since headers are included, use new for now, later see if CreatClass will work or not
		/*
		///Jasmine 11/29/05 QA70-8352 v8.0341 MODIFICATION_FINDCLASS
		string strClass;
		switch(nType)	
		{
		case PB_BROWSER_PAGE_LIST:
			//m_pPBList = new PBPageList;	
			strClass = "PBPageList";
			break;
		case PB_BROWSER_LAYER_LIST:
			//m_pPBList = new PBLayerList;
			strClass = "PBLayerList";
			break;
		default:
			return false;
		}
		PBListBase& PBList = (PBListBase&) Project.CreateClass(strClass); //CPY 11/30/05, change from FindClass
		m_pPBList = &PBList;
		///End MODIFICATION_FINDCLASS
		*/
		//temp
		m_pPBList = NULL;
		int nType;		
		if(0 == strGridList.CompareNoCase("PBPageList"))
		{
			//m_pPBList = new PBPageList;	///jasmine 12/12/05
			nType = PB_BROWSER_PAGE_LIST;
		}
		if(0 == strGridList.CompareNoCase("PBLayerList"))
		{
			//m_pPBList = new PBLayerList;	///jasmine 12/12/05
			nType = PB_BROWSER_LAYER_LIST;
		}
		///Jasmine, Folger 05/05/07 QA80-9654 IMPROVE_PB_FOR_COLUMN_BROWSER
		if(0 == strGridList.CompareNoCase("PBObjectList"))
		{
			nType = PB_BROWSER_OBJECT_LIST;
		}
		///End IMPROVE_PB_FOR_COLUMN_BROWSER
		//------------------------------ end CPY 11/30/05
		///Jasmine 12/12/05, FindClass is ok now
		if(strGridList.IsEmpty())
			return false;
		PBListBase& PBList = (PBListBase&) Project.FindClass(strGridList);
		m_pPBList = &PBList;
		///End
		if(m_pPBList == NULL)
			return false;
		m_strGridListClass = strGridList;///Jasmine 12/16/05 SET_CLASS_NAME_ATTRIB
		m_PBBrowserType = nType;
		return true;
	}
	BOOL UpdateListPanel(TreeNode trNode)
	{
		///Sophy CLEAN_CODE_PBLIST_CONTROL
		/*
		///Jasmine 04/04/07 MAKE_A_GOOD_COL_WIDTH, auto size col after update
		//return m_pPBList->UpdateList(trNode, m_nPageFilterType);
		if(!m_pPBList->UpdateList(trNode, m_nPageFilterType))
			return FALSE;
		m_pPBList->ResizeCols();
		return TRUE;;
		///End MAKE_A_GOOD_COL_WIDTH
		*/
		vector<string>	vsItems;
		vector<int>		vnPageType;
		vector<DWORD>	vdwStatus;
		m_pPBList->GetItems( trNode, 
							vsItems, vnPageType, vdwStatus, 
							m_nPageFilterType,
							m_bIncludeShortcut);	///Jasmine 04/27/10 QA81-14826-P5 BROWSER_HAS_INCLUDE_SHORTCUT_OPTION
		m_pPBList->UpdateList( vsItems, vnPageType, vdwStatus );
		
		return true;
		///end Sophy CLEAN_CODE_PBLIST_CONTROL
	}
	///End INHERIT_FROM_TREELISTEDITSPLITTER

	void OnPageSelChange(Control cntrl)
	{
		if(!m_bReady)
			return;
		//printf("m_bReady and OnPageSelChange\n");
		vector<string> vsSelPages;
		string strSel = "\"";
		
		if(!m_pPBList->GetSelItems(vsSelPages) || vsSelPages.GetSize() == 0)
			strSel = "" ;
		
		if(vsSelPages.GetSize() == 1)
			strSel = vsSelPages[0];
		else
		{
			for(int n =0; n < vsSelPages.GetSize(); n++)
				strSel += vsSelPages[n] + "\"";
			}
		///Joseph  09/04/06 ADD_PREVIEW_ON_PROJECT_BROWSER
		m_strGraphName = strSel;//vsSelPages[0]; ///Jasmine 12/27/06 we should get the whole selection
		//if(!UpdateNameControl(strSel))
			//return;
		///End ADD_PREVIEW_ON_PROJECT_BROWSER
		Window Wnd = GetParent();
		if(Wnd)
			Wnd.PostMessage( WM_USER_ON_NAME_CHANGE );
	}

	void OnFolderSelected(Control ctrl)
	{		
		//int GetCollapsed(int nRow); //return -1 if not applicable, otherwise 1 = collapsed, 0 = expended
		///Jasmine 12/16/05 INHERIT_FROM_TREELISTEDITSPLITTER
		/*
		int nCurFolColl = m_folders.GetCollapsed(m_nCurFolderRow);
		_DMSG_PB("ddddd");
		bool bIsCollasped = true;
		if(nCurFolColl == 2)
			bIsCollasped = false;
		m_folders.SetCollapsed(m_nCurFolderRow, bIsCollasped);
		OnUpdateFolderList(ctrl);
		*/

		/// Bill 07/09/2010 QA81-14826-P2 SHOW_LONG_NAME_AND_LIST_VIEW_MENU
		if ( !m_bShowTreeView )
			return;
		/// End SHOW_LONG_NAME_AND_LIST_VIEW_MENU

		int nClickRow, nClickCol;
		m_pTree->GetMouseCell(nClickRow, nClickCol);

		/// Bill 07/12/2010 ORG-533-P6 CHECK_IF_NO_ITEM_SELECTED
		if ( nClickRow < 0 || nClickRow < 0 )
			return;
		/// End CHECK_IF_NO_ITEM_SELECTED

		TreeNode trClickNode = tree_get_node(m_tree, nClickRow);
		if(trClickNode.GetNodeCount())
		{		
			int nCurFolColl = m_pTree->GetCollapsed(nClickRow);
			//m_pTree->SetCollapsed(m_nCurFolderRow, (flexOutlineCollapsed == nCurFolColl)? false : true);
			m_pTree->SetCollapsed(nClickRow, (flexOutlineCollapsed == nCurFolColl)? false : true);
			//OnSelectTreeNode(ctrl);
			int nIcon;
			trClickNode.GetAttribute(STR_DISPLAY_ATTRIB, nIcon);
			if(nIcon == IDI_FOLDER_CLOSED || nIcon == IDI_FOLDER_OPEN)
			{
				trClickNode.SetAttribute(STR_DISPLAY_ATTRIB, flexOutlineCollapsed == nCurFolColl? IDI_FOLDER_OPEN : IDI_FOLDER_CLOSED);
				SetActive(nClickRow, flexOutlineCollapsed == nCurFolColl);
			}
		}
		///End INHERIT_FROM_TREELISTEDITSPLITTER
	}
	
	///Jasmine 02/21/10 QA81-14826-P2 ADD_CONTEXT_MENU_TO_PB_TREE
	void OnBeforeMouseDownInTree(Control cntrl, short nButton, short nShift, float X, float Y, BOOL* pCancel)
	{
		int nRow, nCol;
		m_pTree->GetMouseCell(nRow, nCol);
		if(MK_RBUTTON != nButton || 0 != nShift || nCol < 0)
			return;
		
		int nx = m_pTree->XTwipsToPixels(X);
		int ny = m_pTree->YTwipsToPixels(Y);
		m_pTree->ClientToScreen(nx, ny);
		
		PBTreeMenu	myMenu(m_bShowLongName);//temp
		Window wnd = GetParent();
		if(wnd)
		{
			myMenu.TrackPopupMenu(0, nx, ny, wnd.GetSafeHwnd());
			int nCmd;
			if(myMenu.GetCommand(nCmd))
			{
				switch(nCmd)
				{
				case PB_TREE_MENU_SHOW_LN:
					OnShowLNameChecked();
					break;
				///Jasmine 02/21/10 QA81-14826-P3 WANT_LIST_VIEW_OPTION
				case PB_TREE_MENU_LIST_VIEW:	
					OnListViewChecked();			
					break;
				///End WANT_LIST_VIEW_OPTION
				default:
					break;
				}
			}
		}			
	}
	///End ADD_CONTEXT_MENU_TO_PB_TREE
	
	/// Bill 07/09/2010 QA81-14826-P2 SHOW_LONG_NAME_AND_LIST_VIEW_MENU
	void OnShowLNameChecked()
	{
		m_bShowLongName = !m_bShowLongName;

		if ( m_bShowTreeView )
			ShowNameInTree();	
		else
			ShowNameInList();
	}

	void ShowNameInTree()
	{
		if ( m_bShowLongName )
			ShowLongNameInTree();
		else
			ShowShortNameInTree();
	}

	void ShowLongNameInTree()
	{
		vector<string> vsLabel;

		GetLabelWithLongName(vsLabel);

		FillTheTree(vsLabel);
	}

	void ShowShortNameInTree()
	{
		vector<string> vsShortNames;

		GetShortName(vsShortNames);

		FillTheTree(vsShortNames);
	}

	void FillTheTree(const vector<string> & vsNames)
	{
		for (int nRow = 0 ; nRow < vsNames.GetSize() ; ++nRow)
			m_pTree->SetCell(nRow, 0, vsNames[nRow]);
	}

	void ShowNameInList()
	{
		if ( m_bShowLongName )
			ShowLongNameInList();
		else
			ShowShortNameInList();
	}

	void ShowLongNameInList()
	{
		m_pTree->HideCol(LIST_SHORT_NAME_COL, false);
		m_pTree->HideCol(LIST_LONG_NAME_COL, false);
	}

	void ShowShortNameInList()
	{
		m_pTree->HideCol(LIST_SHORT_NAME_COL, false);
		m_pTree->HideCol(LIST_LONG_NAME_COL, true);
	}

	void SaveSelectedName()
	{
		int nRow = m_pTree->GetSelectedRow();
		
		if (nRow <= 0)
			return;

		if ( m_bShowTreeView )
		{
			TreeNode trRow;
			int nLevel;

			trRow = tree_get_node(m_tree, nRow);

			trRow.GetAttribute(STR_STOP_ATTRIB, nLevel);
			if ( PTL_FOLDER == nLevel )
			{
				if ( trRow.FirstNode )
				{
					trRow = trRow.FirstNode;
					
					trRow.GetAttribute(STR_STOP_ATTRIB, nLevel);
					if ( PTL_PAGE == nLevel )
						trRow.GetAttribute(STR_LABEL_ATTRIB, m_strSelectedName);
					else
						m_strSelectedName = "";
				}
				else
				{
					m_strSelectedName = "";
				}
			}
			else if ( PTL_PAGE == nLevel )
			{
				trRow.GetAttribute(STR_LABEL_ATTRIB, m_strSelectedName);
			}
		}
		else
		{
			m_strSelectedName = m_pTree->GetCell(nRow, LIST_SHORT_NAME_COL);
		}
	}

	void ShowTreeView()
	{
		m_pTree->HideCol(LIST_SHORT_NAME_COL, false);
		m_pTree->HideCol(LIST_SHORT_NAME_COL, false);
		m_pTree->SetupRowsCols(0, 0);
		
		InitTreePanel(m_nPageFilterType);
		
		int nSelectRow = GetRowNumberBySaveName();
		m_pTree->CheckSelRow(nSelectRow, true);
		m_strSelectedName = "";
	}

	void ShowListView()
	{
		ShowListPanel(m_nPageFilterType);
		
		int nSelectRow = GetRowNumberBySaveName();
		m_pTree->CheckSelRow(nSelectRow, true);
		m_strSelectedName = "";
	}

	void GetLabelWithLongName(vector<string> & vsLabel)
	{
		string strLabel, strLongName, strShortName;
		int nLevel;

		for (int nRow = 0 ; /* empty */ ; ++nRow)
		{
			TreeNode trRow = tree_get_node(m_tree, nRow);
			if( !trRow.IsValid() )
				break;
			
			trRow.GetAttribute(STR_STOP_ATTRIB, nLevel);
			if( PTL_PAGE != nLevel )
			{
				trRow.GetAttribute(STR_LABEL_ATTRIB, strLabel);
			}
			else
			{
				trRow.GetAttribute(STR_LABEL_ATTRIB, strShortName);
				trRow.GetAttribute(STR_NAME_ATTRIB, strLongName);
				strLabel = strShortName + " - " + strLongName;
			}

			vsLabel.Add(strLabel);
		}
	}

	void GetShortName(vector<string> & vsShortNames)
	{
		string strLabel;
		int nLevel;

		for (int nRow = 0 ; /* empty */ ; ++nRow)
		{
			TreeNode trRow = tree_get_node(m_tree, nRow);
			if(!trRow.IsValid())
				break;

			trRow.GetAttribute(STR_LABEL_ATTRIB, strLabel);
			vsShortNames.Add(strLabel);
		}
	}
	/// End SHOW_LONG_NAME_AND_LIST_VIEW_MENU

	///Jasmine 12/27/06 PUT_BACK_DBCLICK_IN_LIST_PANEL
	///Joseph  09/04/06 ADD_PREVIEW_ON_PROJECT_BROWSER
	void OnBrowserListFolderSelted(Control ctrl)
	{
		string strPageName;
		//if(!m_pPBList->GetSelItem(strPageName))
			//return;
		vector<string> vsSel;
		if(!m_pPBList->GetSelItems(vsSel, true) || vsSel.GetSize()<=0)
			return;
		
		strPageName = vsSel[0];
		
		int nRow ;//= m_flx.MouseRow;
		int nCol ;//= m_flx.MouseCol;
		m_pPBList->GetMouseCell(nRow, nCol);
		
		if(m_pPBList->GetRowOffset() > nRow)
			return;
		
		//if(m_pages.IsPage(nRow) == ITEM_IS_FOLDER)
		if(m_pPBList->GetItemType(nRow) == ITEM_IS_FOLDER)
		{
			//int nSelectedRow = m_folders.GetFolderSelFromBrowserListSel(strPageName);	///Jasmine 12/16/05 REMOVE_PBFOLDERSLIST
			int nSelectedRow = GetSelRow(strPageName);
			//setFolderListSel(nSelectedRow);
			
			//GetSelectedFolder(strPageName, nSelectedRow);	///Jasmine 12/16/05 REMOVE_PBFOLDERSLIST
	
			SetActive(nSelectedRow);
			//_DMSG_PB("Yes, is folder");	
		}
		else
			{
				Window Wnd = GetParent();
				if(Wnd)
					Wnd.PostMessage( WM_USER_ON_DBCLICK_SELETED );
			}
	}
	///End ADD_PREVIEW_ON_PROJECT_BROWSER
	///End PUT_BACK_DBCLICK_IN_LIST_PANEL
	BOOL OnActiveLayerChange( void )
	{
		Control cntl;
		//OnUpdateFolderList(cntl);	///Jasmine 12/16/05 INHERIT_FROM_TREELISTEDITSPLITTER
		OnSelectTreeNode(cntl);
		return true;
	}
	void OnBeforeMouseDown(Control cntrl, short nButton, short nShift, float X, float Y, BOOL* pCancel)
	{
		//-------Folger 07/16/07 POPUP_SHOW_HIDE_COLUMN_MENU_IN_PB_LIST
		int nRow, nCol;
		m_pPBList->GetMouseCell(nRow, nCol);
		if(MK_RBUTTON == nButton && 0 == nShift)
		{
			int nx = m_pPBList->XTwipsToPixels(X);
			int ny = m_pPBList->YTwipsToPixels(Y);
			m_pPBList->ClientToScreen(nx, ny);
			int nCmd;

			if(nCol >= 0)
			{
				//--------Folger 07/17/07 USE_CONTEXT_MENU_IN_PB_LIST_BASE
				m_pPBList->ShowMenu(nx, ny);
				//--------End USE_CONTEXT_MENU_IN_PB_LIST_BASE
			}
		}
		//-------End POPUP_SHOW_HIDE_COLUMN_MENU_IN_PB_LIST
	}
	///Jasmine 12/16/05 SET_CLASS_NAME_ATTRIB
	virtual void SetClassNameAttrib()
	{
		//void tree_set_attribute_to_all_nodes(TreeNode& tr, LPCSTR lpcszAttrib, 
											//LPCSTR lpcszAttribVal, 
											//bool b1stLevelChildrenOnly = false, 
											//bool bBranchOnly = false);
		tree_set_attribute_to_all_nodes(m_tree, STR_CLASS_NAME_ATTRIB, m_strGridListClass);
	}
	///End SET_CLASS_NAME_ATTRIB
public:
	///Joseph  09/04/06 ADD_PREVIEW_ON_PROJECT_BROWSER	
	string GetGraphName()
	{
		return m_strGraphName;
	}
	///End ADD_PREVIEW_ON_PROJECT_BROWSER
	
	/// Bill 07/09/2010 QA81-14826-P2 SHOW_LONG_NAME_AND_LIST_VIEW_MENU
	void OnListViewChecked()
	{
		SaveSelectedName();
		m_bShowTreeView = !m_bShowTreeView;

		if (m_bShowTreeView)
			ShowTreeView();
		else
			ShowListView();
	}
	/// End SHOW_LONG_NAME_AND_LIST_VIEW_MENU	
	
	bool OnTypeChange( int nPageFilterType = -1)
	{
		if(nPageFilterType == -1)	
		{
			///Joseph  09/04/06 ADD_PREVIEW_ON_PROJECT_BROWSER
			//if(!isAppendControlValid(PB_CNTL_TYPE_LIST))
			if(!isAppendControlValid())
			///End ADD_PREVIEW_ON_PROJECT_BROWSER
			{
				m_nPageFilterType = -1;
			}
			else
				//nPageFilterType = m_comTypeList.GetCurSel();
				{
					int nTemp = m_comTypeList.GetCurSel();
					string strTypeName ;
					m_comTypeList.GetLBText(nTemp, strTypeName);
					nPageFilterType = getPageType(strTypeName);
				}
			
			//m_nPageFilterType = getFilterPageType(nPageFilterType);
			m_nPageFilterType = nPageFilterType;
		
		}
		else
		{
			//m_nPageFilterType = getFilterPageType(nPageFilterType);
			m_nPageFilterType = nPageFilterType;
			setFilterPageType(nPageFilterType);
		}
		
		//_DMSG_PB("PE folder sel changes");
		//int nSelRow =0 ;
		///Jasmine 12/16/05 INHERIT_FROM_TREELISTEDITSPLITTER
		/*
		Folder fldr = m_folders.GetSelectedFolder(m_nCurFolderRow);
		//m_pages.UpdateList(fldr, m_nPageFilterType);
		m_pPBList->UpdateList(fldr, m_nPageFilterType);
		*/

		/// Bill 07/12/2010 ORG-533-5 ACTIVE_THE_RIGHT_ITEM
		if ( !m_bShowTreeView )
			return true;

		string strLabel;
		int nSelRow;
		TreeNode trRow;
		
		nSelRow = m_pTree->GetSelectedRow();
		if ( nSelRow < 0 )
			nSelRow = 0;
		trRow = tree_get_node(m_tree, nSelRow);
		trRow.GetAttribute(STR_LABEL_ATTRIB, strLabel);
		m_strSelectedName = strLabel;
		/// End ACTIVE_THE_RIGHT_ITEM

		UpdateTreePanel(m_nPageFilterType);	///Jasmine 12/25/06 BOTH_TREE_PANEL_AND_PBLIST_SHOULD_SHOW_THE_SAME_TYPE
		///Joseph  09/04/06 ADD_PREVIEW_ON_PROJECT_BROWSER
		/// Bill 07/12/2010  ORG-533-5 ACTIVE_THE_RIGHT_ITEM
		//TreeNode trSelFolder = tree_get_node(m_tree, m_pTree->GetSelectedRow());
		TreeNode trSelFolder = GetTreeNodeBySaveName();
		m_pTree->CheckSelRow(GetRowNumberBySaveName(), true);
		/// End ACTIVE_THE_RIGHT_ITEM
		///Sophy CLEAN_CODE_PBLIST_CONTROL
		//m_pPBList->UpdateList(trSelFolder, m_nPageFilterType);
		vector<string>	vsItems;
		vector<int>		vnPageType;
		vector<DWORD>	vdwStatus;
		m_pPBList->GetItems( trSelFolder, 
							vsItems, vnPageType, 
							vdwStatus, 
							m_nPageFilterType,
							m_bIncludeShortcut);	///Jasmine 04/27/10 QA81-14826-P5 BROWSER_HAS_INCLUDE_SHORTCUT_OPTION
		m_pPBList->UpdateList( vsItems, vnPageType, vdwStatus );
		///end Sophy CLEAN_CODE_PBLIST_CONTROL
		//m_pPBList->UpdateList(tree_get_node(m_tree, m_nCurFolderRow), m_nPageFilterType);
		///End ADD_PREVIEW_ON_PROJECT_BROWSER
		///End INHERIT_FROM_TREELISTEDITSPLITTER
		
		return true;
	}
	//--------Folger 07/03/07 CLEAN_UP_GET_RANGE_STRING_CODE
	//string GetSelectedPage()
	int GetSelectionRangeString(vector<string> &vsSelected)
	//--------end CLEAN_UP_GET_RANGE_STRING_CODE
	{
		///Folger 06/18/07 MODIFY_GET_SELECTED_PAGE
		//return m_pages.GetSelectedPage(strPageName) && m_pages.IsPage(strPageName);
		//string nSelPageRow;
		//vector<string> vsSel;
		//if(m_pPBList->GetSelItems(vsSel) && vsSel.GetSize()>= 0)
		//{
			//nSelPageRow.SetTokens(vsSel);		///Folger 05/08/07 MODIFY_PB_COLUMN_BROWSER
		//}
		//
		//return nSelPageRow;
		//--------Folger 07/03/07 CLEAN_UP_GET_RANGE_STRING_CODE
		//return m_pPBList->GetSelectionRangeString();
		return m_pPBList->GetSelectionRangeString(vsSelected);
		//--------end CLEAN_UP_GET_RANGE_STRING_CODE
		///End MODIFY_GET_SELECTED_PAGE
	}
	///Joseph  09/04/06 ADD_PREVIEW_ON_PROJECT_BROWSER
	//string GetSelectedPages()
	//{
		//string strSelect = "";
		////if(isAppendControlValid(PB_CNTL_NAME_EDIT))
			//strSelect = m_edName.Text;
		//return strSelect;
	//}
	///End ADD_PREVIEW_ON_PROJECT_BROWSER
	///Jasmine 12/16/05 REMOVE_PBFOLDERSLIST
	/*
	int GetSelectedFolder(LPCSTR lpcszFolderString, int nRow )
	{
		if(!lpcszFolderString)
			return -1;
		
		string strFolder = lpcszFolderString;
		strFolder.TrimLeft();
		
		vector<string> vsFolders;
		int nFolderLevels = strFolder.GetTokens(vsFolders, PB_FOLDER_SHOW_SEPARATE_CHAR);
		
		return nRow;
	}
	*/
	///End REMOVE_PBFOLDERSLIST
	void SetActive(int nRow, bool bExpand = true)
	{
 		///Jasmine 12/16/05 INHERIT_FROM_TREELISTEDITSPLITTER
		/*
		m_folders.SetFolderIconClosed(m_nCurFolderRow);
		m_nCurFolderRow = nRow;
		
		m_folders.SetActive(nRow);
		m_folders.SetFolderIconOpen(nRow);
		*/
		//m_pTree->SetCellIcon(m_nCurFolderRow, 0, IDI_FOLDER_CLOSED, MODULE_ORIGIN);
		m_nCurFolderRow = nRow;
		m_pTree->SelRow(nRow);
		m_pTree->SetCellIcon(nRow, 0, bExpand? IDI_FOLDER_OPEN : IDI_FOLDER_CLOSED, MODULE_ORIGIN);
		///End INHERIT_FROM_TREELISTEDITSPLITTER
	}
	///Set the splitter setting, set the selected mode and show page type.
	///nSelectedMode can be MULTIPLE_SELECT and SINGLE_SELECT, mean multiple select the items and single one selected.
	///nOnlyShowLayers can be 	EXIST_WKS, EXIST_GRAPH, EXIST_MATRIX, EXIST_LAYOUT, EXIST_NOTES, EXIST_NONE
	///EXIST_WKS mean only show worksheet or workbook in browser.
	///EXIST_NONE mean can show all page and layers.
	///vnTypeList will update the TypeList box.
	//void InitSplitterSetting(int nSelectedMode, int nOnlyShowLayers, vector<int> &vnTypeList = NULL)	///Jasmine 12/16/05 CONTROL_TREE_LEVEL
	///Jasmine 12/25/06 BOTH_TREE_PANEL_AND_PBLIST_SHOULD_SHOW_THE_SAME_TYPE
	//void InitSplitterSetting(int nSelectedMode, int nLevel, int nOnlyShowLayers, vector<int> &vnTypeList = NULL)	
	void InitSplitterSetting(int nSelectedMode, int nLevel, vector<int> &vnTypeList = NULL)
	{
		m_nSelectMode = nSelectedMode;
		//m_nPageFilterType = nOnlyShowLayers;
		m_nLevel = nLevel;	///Jasmine 12/16/05 CONTROL_TREE_LEVEL
		m_vnTypeList = vnTypeList;
		m_nPageFilterType = m_vnTypeList.GetSize()? m_vnTypeList[0] : EXIST_NONE;
	///End BOTH_TREE_PANEL_AND_PBLIST_SHOULD_SHOW_THE_SAME_TYPE
		//vector<uint> vn;
		//if(m_vnTypeList.GetSize() <=0 ||m_vnTypeList.Find(vn, 0) <= 0)
			//m_vnTypeList.Add(0);
	}
	int CountTypeList(){ return m_vnTypeList.GetSize();}
	///Jasmine 12/16/05 INHERIT_FROM_TREELISTEDITSPLITTER
	int GetSelRow(string strSelItem)
	{
		int nSelRow = m_pTree->GetSelectedRow();
		nSelRow = m_pTree->FindRow(strSelItem, 0, false, true, nSelRow);
			 			//FindRow(LPCSTR lpcszRowText, int nCol = 0,bool bCaseSensitive = false,
				    			//bool bFullmatch = true, int nStartRow = -1);		
		if(nSelRow <= 0)
			return 0;
		return nSelRow;
	}
	///Jasmine, Folger 05/05/07 QA80-9654 IMPROVE_PB_FOR_COLUMN_BROWSER
	int GetPageFilterType()
	{
		return m_nPageFilterType;
	}
	///Folger 05/08/07 MODIFY_PB_COLUMN_BROWSER
	string GetSelWks()
	{
		string strName;
		TreeNode trSel = tree_get_node(m_tree, m_pTree->GetSelectedRow());
		trSel.GetAttribute(STR_LABEL_ATTRIB, strName);
		return strName;
	}
	///End MODIFY_PB_COLUMN_BROWSER
	///End IMPROVE_PB_FOR_COLUMN_BROWSER
	///End INHERIT_FROM_TREELISTEDITSPLITTER
	///Folger 06/20/07 CREATE_GET_INIT_RANGE_STRING
	bool GetInitRangeString(vector<string> &vsVals)
	{
		m_pPBList->GetInitRangeString(vsVals);
		return true;
	}
	///End CREATE_GET_INIT_RANGE_STRING
private:
	///init the project browser support type, if vsTypeList = NULL, mean user set the default type list,
	///else user input the list, need to check the browser support or not, if not support, remove it.
	//bool loadProjectBrowserType(vector<string> &vsTypeList = NULL)
	bool loadProjectBrowserType(vector<int> &vnTypeList)
	{
		///Joseph  09/04/06 ADD_PREVIEW_ON_PROJECT_BROWSER
		//if(!isAppendControlValid(PB_CNTL_TYPE_LIST))
		if(!isAppendControlValid())
		///End ADD_PREVIEW_ON_PROJECT_BROWSER
			return false;
	
		//second parameter will add the show_all into the type list...
		getBrowserTypeList(vnTypeList, true);
		
		for(int n = vnTypeList.GetSize() -1; n >= 0; n--)
			m_comTypeList.InsertString(0, getPageTypeName(vnTypeList[n]));

		int nSelType = m_nPageFilterType;
		if(nSelType == -1)
			nSelType = vnTypeList[0];
		setFilterPageType( nSelType );
		
		return true;
	}
	bool getBrowserTypeList(vector<int> &vnList, bool bAddAllType = true)
	{
		vector<int> vnTypeLit;
		m_pPBList->GetBrowserSupportTypeList(vnTypeLit);

		if(vnTypeLit.GetSize() <= 0)
			return false;
		
		if(vnList.GetSize() == 0)
		{
			vnList = vnTypeLit;
			return true;
		}
		
		vector<uint> vn;
		for(int nListIndex =vnList.GetSize()-1; nListIndex < 0; nListIndex --)
		{
			if(vnTypeLit.Find(vn, vnList[nListIndex]) < 0 )
				vnList.RemoveAt(nListIndex);			
		}
		if(vnList.GetSize() <=0 || (vnList.Find(vn, 0) <= 0 && vnList.GetSize() >1))
			vnList.Add(0);
		return true;
	}
	void setFilterPageType(int nFilterIndex =-1)
	{
		vector<uint> vn;
		m_vnTypeList.Find(vn, nFilterIndex);
		if(vn.GetSize() > 0)
		{
			m_nPageFilterType = nFilterIndex;

			m_comTypeList.SetCurSel(vn[0]);		
		}
	}

	int getPageType(LPCSTR lpcszPageName)
	{
		string strType = lpcszPageName;
		char 	cType =strType.GetAt(0) ;
		int nPageType;
		switch(cType)
		{
		case 'W': 
			nPageType = EXIST_WKS;
			break;
		case 'G':
			nPageType = EXIST_GRAPH;
			break;
		case 'M':
			nPageType = EXIST_MATRIX;
			break;
		case 'N':
			nPageType = EXIST_NOTES;
			break;
		case 'L':
			if(strType.Compare("Layout") == 0)
				nPageType = EXIST_LAYOUT;
			else
				nPageType = EXIST_LAYOUT;
			break;
					
		case 'A':
			
		default:
			nPageType = EXIST_NONE;
			break;
		}
		return nPageType;
	}
	string getPageTypeName(int nPageType )
	{
		string strPageTypeName;
		switch(nPageType)
		{
		case EXIST_WKS:
			strPageTypeName =  _L("Workbook");
			break;
		case EXIST_GRAPH:
			strPageTypeName =  _L("Graph");
			break;
		case EXIST_MATRIX:
			strPageTypeName =  _L("Matrix");
			break;
		case EXIST_NOTES:
			strPageTypeName =  _L("Note");
			break;
		case EXIST_LAYOUT:
			strPageTypeName =  _L("Layout");
			break;

		case EXIST_DATA:
		//case EXIST_PLOT:
			strPageTypeName =  _L("Layers");
			break;
		case EXIST_NONE:
		default:
			strPageTypeName =  _L("All");
			break;
		}
		return strPageTypeName;
	}
	///Joseph  09/04/06 ADD_PREVIEW_ON_PROJECT_BROWSER
	//bool updateFolderComboList()
	//{
		//if(!isAppendControlValid(PB_CNTL_FOLDER_LIST))
			//return false;
//
		//vector<string> vsList;
		////m_folders.GetFoldersComboString(vsList);///Jasmine 12/16/05 REMOVE_PBFOLDERSLIST
		//_get_project_combobox_strings(m_tree, vsList);
		//
		//m_vsFolderList = vsList;
		//
		//m_comFolderList.ResetContent();
		//
		//for(int n = vsList.GetSize() -1; n >= 0; n--)
			////m_comFolderList.AddString(vsList[n]);
			//m_comFolderList.InsertString(0, vsList[n]);
	//
		//setFolderListSel(0);
		//return true;
	//}
	///End ADD_PREVIEW_ON_PROJECT_BROWSER
	bool isAppendControlValid()
	{
		///Joseph  09/04/06 ADD_PREVIEW_ON_PROJECT_BROWSER
		//bool bRet ;
		//switch(nCntrType)
		//{
			//case PB_CNTL_FOLDER_LIST:
				//return m_comFolderList == NULL ? false : true;
			//case PB_CNTL_UP_BOTTON:
				//return m_chkUpBottom == NULL ? false : true;
			//case PB_CNTL_TYPE_LIST:
				//return m_comTypeList == NULL ? false : true;
			//case PB_CNTL_NAME_EDIT:
				//return m_edName == NULL ? false : true;
			//default:
				//return false;
		//}
		//return false;		
		return m_comTypeList == NULL ? false : true;
		///End ADD_PREVIEW_ON_PROJECT_BROWSER
	}
	void selectallpage()
	{
		vector<int> nRows;
		//m_pages.GetAllPages(nRows);
		//m_pages.SelRows(nRows);
		m_pPBList->SetAllItemSel(nRows);
		m_pPBList->SelRows(nRows);
	}
	bool isLayerBrowserList()
	{
		return m_pPBList->GetPBListType() == PB_BROWSER_LAYER_LIST;
	}
	//---------Folger 07/13/07 EXCLUDE_RESULT_SHEET_IN_COLUMN_BROWSER_IS_NEEDED
	void excludeResultSheet(TreeNode &tr)
	{
		foreach(TreeNode trNode in tr.Children)
		{
			string strLabel;
			trNode.GetAttribute(STR_LABEL_ATTRIB, strLabel);
			Page pg(strLabel);
			Worksheet wks(strLabel);
			if (wks && !pg && (wks.GetSystemParam(0) & WP_SHEET_HIERARCHY))
				trNode.Remove();
			else
				excludeResultSheet(trNode);
		}
	}
	//---------End EXCLUDE_RESULT_SHEET_IN_COLUMN_BROWSER_IS_NEEDED
public:	
	bool						m_bIncludeShortcut;///Jasmine 04/27/10 QA81-14826-P5 BROWSER_HAS_INCLUDE_SHORTCUT_OPTION
	
private:
	
	bool						m_bSupportMultiSelected;
	///Jasmine 12/16/05 INHERIT_FROM_TREELISTEDITSPLITTER	
	/*
	bool						m_bReady;	
	int							m_IDfolders;// control ID for panes		
	int							m_IDpages;
	*/
	///End INHERIT_FROM_TREELISTEDITSPLITTER
	//PBPageList 		 			m_pages;
	PBListBase 		 			*m_pPBList;
	//PBFoldersList	 		 	m_folders;///Jasmine 12/16/05 REMOVE_PBFOLDERSLIST
	string						m_strDlgName;
	int							m_nPageFilterType;
	int							m_nLevel;
	vector<string>				m_vsFolderList;
	int 						m_nCurFolderRow;
	vector<bool>				m_vbViewState;
	vector<int> 				m_vnTypeList;

	int							m_nSelectMode;
	int							m_nFileType;
	
	int 						m_PBBrowserType;
	///Joseph  09/04/06 ADD_PREVIEW_ON_PROJECT_BROWSER
	//BitmapRadioButton			m_chkUpBottom;
	//ComboBox					m_comFolderList;
	///End ADD_PREVIEW_ON_PROJECT_BROWSER
	ComboBox					m_comTypeList;
	///Joseph  09/04/06 ADD_PREVIEW_ON_PROJECT_BROWSER
	//Edit						m_edName;	
	string 						m_strGraphName;
	///End ADD_PREVIEW_ON_PROJECT_BROWSER
	DWORD m_dwFilter;//bool						m_bResultSheet;		//---------Folger 07/13/07 EXCLUDE_RESULT_SHEET_IN_COLUMN_BROWSER_IS_NEEDED///Jasmine 09/28/07 FILTER_OUT_NON_IMAGE_MATRIX	

	/// Bill 07/09/2010 QA81-14826-P2 SHOW_LONG_NAME_AND_LIST_VIEW_MENU
	bool						m_bShowLongName;
	bool						m_bShowTreeView;
	string						m_strSelectedName;
	/// End SHOW_LONG_NAME_AND_LIST_VIEW_MENU
};
static int  get_node_by_label(const TreeNode& tr, TreeNode &trDestination, LPCSTR lpcszLable, bool bUseLabelFirst = true)
{
	if(!tr)
		return "";
	string strNodeLabel;
	int nRow = 0;
	
	foreach(TreeNode cnode in tr.Children)
	{
		string strTemp;
		if(!cnode.GetAttribute(STR_DISPLAY_ATTRIB, strTemp))
			continue;
		
		nRow++;
		
		if(lpcszLable != NULL)
		{
			if(!bUseLabelFirst)
				strNodeLabel = cnode.tagName;
			else
				cnode.GetAttribute(STR_LABEL_ATTRIB, strNodeLabel);
			
			if(strNodeLabel.CompareNoCase(lpcszLable) == 0)
				return nRow;
		}

		if(cnode.GetNodeCount() >0)
			nRow +=get_node_by_label(cnode, trDestination, NULL);
	}
	
	return nRow;
}
static void _get_project_combobox_strings(TreeNode &trProject, vector<string> &vsComboString ,int nSelectedRow = 0, LPCSTR lpcszPrefixOfFolder = NULL)
{
	if(!trProject)
		return ;
	
	string strTemp ;
	string strPrefix = lpcszPrefixOfFolder;
	if(strPrefix.IsEmpty())
		//strPrefix = "  ";
		strPrefix =PB_FOLDER_SHOW_SEPARATE_CHAR;
		
	vector<string> vecCurrentFolder;
	foreach(TreeNode cNode in trProject.Children)
	{
		string strTemp;
		if(!cNode.GetAttribute(STR_DISPLAY_ATTRIB, strTemp))
			continue;
		
		//strTemp = strPrefix + PB_FOLDER_SHOW_SEPARATE_CHAR + get_node_label(cNode, true);
		strTemp = strPrefix + get_node_label(cNode, true) + PB_FOLDER_SHOW_SEPARATE_CHAR;

		vsComboString.Add(strTemp);
		if(cNode.GetNodeCount() > 0 )
			_get_project_combobox_strings(cNode, vsComboString, nSelectedRow, strTemp);
	}
}

#endif ///_PB_FUNCTION_LIST_H
